# Contributing/Developing

## Types of Contributions

GLI is relatively stable.  As such:

* No major new features should be added
* No refactorings or "modernization" is desired
* No runtime dependencies should be added.

If you really want to make a change like this, open an issue first to discuss.

That said, I welcome:

* Bugfixes
* Doc changes
* Minor improvements

I am responsive on issues, so reach out there if you have a question.

## How to Do Development

GLI us using a Docker-based development system to ensure consistency.  To use it, you will need to have Docker installed, as well
as Bash.  This should all work under Windows Subsystem for Linux.

### Setting Up

1. Install Docker
2. `dx/build`

   This will use `Dockerfile.dx` to create one Docker image for each supported Ruby version (see `dx/docker-compose.env`'s `RUBY_VERSIONS` variable for the current list).  This will also generate `docker-compose.dx.yml` which will run all versions of Ruby for GLI at the same time.
3. `dx/start`

   This will start Docker using `docker-compose.dx.yml`, which will run containers for all the images generated by `dx/build`

4. From here, you can run commands inside the running containers, or you can run `bash` inside a container to effectively "log
   in" and run commands.

### Doing Development

Once you are set up, you should run `dx/exec bash`.  This will log you into the container running the oldest supported version of
Ruby.  This is the version where you should do your basic work. This container has access to the source code you cloned from
GitHub.

1. `on-your-computer> dx/exec bash`
2. `inside-docker-container> bin/setup # installs all gems`
3. `inside-docker-container> bin/rake  # runs all tests`

Once you have stuff working, run tests on the other versions.  Since the container you were working in was operating on your
checked-out files, the other containers will have access as well.

1. `on-your-computer> dx/exec -v 3.3 bash # connects to the conatiner where Ruby 3.3 is installed`
2. `inside-docker-container> bin/setup # installs all gems`
3. `inside-docker-container> bin/rake  # runs all tests`

You can also try using `bin/ci` on your computer (not inside a Docker container), which will run tests across the entire build
matrix.

#### If You Want To Use Your Local Computer

In theory, GLI can be worked on using RVM, RBEnv, asdf, or whatever other way you want to manage Ruby.  You can create a
`.ruby-version` or `.tool-versions`. These are ignored so you can keep them on your machine.  I don't support this setup, so if
something is wrong, I probably can't help.  This is why I have it set up with Docker.
