# frozen_string_literal: true

module Tasks
  class TaskError < StandardError; end

  # A class for managing a sequence of tasks where a successful task execution
  # is required to start the next one.
  class Pipeline
    class PipelineError < TaskError; end

    def initialize(tasks: [])
      @tasks = tasks
    end

    def <<(task)
      tasks << task
    end

    def execute
      tasks.each_with_index(1) do |task, idx|
        logger.info "Starting task #{idx}/#{tasks.length}"
        task.run
      rescue TaskError => e
        logger.error "Stopping pipeline at task #{idx}/#{tasks.length} because of failure"
        raise PipelineError, "Failed to execute task (#{e})"
      end
    end

    private

    attr_accessor :tasks
  end
end
