# frozen_string_literal: true

require 'flood/tasks/task_common'

module Tasks
  # Compaction helper for borg repositories
  class Compact
    include Logging

    class CompactionError < Tasks::TaskError
    end

    def initialize(target_repo, background: false)
      @target_repo = target_repo
      @background = background
      @cmd = Command.new %w[borg], %w[compact --progress --log-json]
      @cmd.add_arg target_repo
    end

    def run
      logger.info "Starting compaction for #{target_repo}"
      @cmd.start.wait

      raise CompactionError, 'Compaction not successful' unless @cmd.success?

      logger.info "Compaction for #{target_repo} successful"
    end

    private

    attr_accessor :target_repo, :background
  end
end
