# frozen_string_literal: true

require 'logger'

module Logging
  LEVEL_MAP = { 'ERROR' => :error, 'WARN' => :warn, 'INFO' => :info, 'DEBUG' => :debug }.freeze
  METHOD_MAP = { 'error' => :error, 'warning' => :warn, 'info' => :info, 'debug' => :debug }.freeze

  def logger
    Logging.logger
  end

  def self.logger(level = :info)
    level = @level || level
    @elog ||= false
    @logger ||= if @elog
                  Logger.new($stderr, level: level,
                                      datetime_format: '%Y-%m-%d %H:%M:%S',
                                      progname: 'mkbackup',
                                      formatter: proc { |sev, datetime, progname, msg|
                                                   "#{datetime} <#{progname}> [#{sev}] | #{msg}\n"
                                                 })
                else
                  Logger.new($stderr, level: level,
                                      datetime_format: '%Y-%m-%d %H:%M:%S',
                                      progname: 'mkbackup',
                                      formatter: proc { |sev, _, _, msg| "[#{Logging::LEVEL_MAP[sev]}] #{msg}\n" })
                end
  end

  def self.elog=(elog)
    @elog = elog
  end

  def self.level=(level)
    @level = level
    @logger.level = level unless @logger.nil?
  end
end
