# Flood

## What?

A small wrapper for BorgBackup.


## How do I ...

### Set this up?

#### Installation options

You can either build and install the gem directly or add the following section to your `/etc/pacman.conf`:

````conf
[naevius]
SigLevel = PackageRequired
Server = https://packages.naevius.de
````

You then need to add the signing key to your pacman keyring and sign it locally:

Key ID: `77BD21B57679BF6673972EFBBB557F46B361AD77`

1. `sudo pacman-key --keyserver keys.openpgp.org --recv-keys 77BD21B57679BF6673972EFBBB557F46B361AD77`
2. `sudo pacman-key --lsign-key 77BD21B57679BF6673972EFBBB557F46B361AD77`

Then you can sync your pacman databases and install the `ruby-flood-backup` package.

#### Post installation

After the installation has finished do the following:
1. Run `flood-init config` to set up directories and copy an example config to `~/.config/flood/`
2. Edit the example config to your hearts content
3. (Optional) run `flood-init systemd` to install a systemd service and timer file to `~/.config/systemd/user`. The service is set to execute all configured backups and the timer is set to run daily at 1200. Edit these as needed and then enable with `systemd --user enable flood-backup.timer`

If you run `flood-init [command]` as `root`, the files will go into the respective subdirectories under `/etc/`.

### Create a new backup?

If you have already prepared one or more config files, you can run `flood backup` to execute all configured backups or `flood backup config-1[::repo-1,[repo-2] config-2 ...` to execute specific ones.
Use the `--background/-b` flag to reduce the output.

### List available archives?

To list all archives in all repos just execute `flood archives`. If you want to target specific configs or repos you can append `config-name-1[::repo-1[,repo-2]]` to the command. The parts in brackets are optional.

### Get information about a repo?

Use `flood info`. This works identical to `flood archives` in that you can optionally specify which backups and repos to look at.

### Mount a backup?

Let `flood mount` work its magic! The command needs a config name, a repo name, an optional archive and the mountpoint. Example: `flood mount backup-config::local-repo[/2020-01-01 12:00 my-backup] ~/mnt`.

### Perform a repository check?

Use `flood check`. Supports data verification via the `--verify-data` flag. You can specify one or more repos or just don't and check all available repos.

### Anything else?

For more complicated stuff just use Borg directly. You can find the docs for BorgBackup [here](https://borgbackup.readthedocs.io/en/stable/).

## Configuration

Configuration files are expected to go into `~/.config/flood/`.

Run `flood-init config` to create the appropriate directories and copy an example configuration into `~/.config/flood/`.
The config file is extensively commented and should be easy to adapt.

## License

The gem is available as open source under the terms of the [MIT License](https://opensource.org/licenses/MIT).
